package easik.ui.datatype;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * Class is used to create UI for a single platform of a
 * single data type.
 * 
 * @author Kevin Green 2006
 * @since 20006-06-26 Kevin Green
 * @version 2006-06-26 Kevin Green
 */
public class PlatformTypePane extends JPanel{
	/**
	 * The platform options available
	 */
	private String[] _platformOptions;
	/**
	 * The label for the OTHER box
	 */
	private JLabel _otherLabel;
	/**
	 * The box holding all possible datatypes
	 */
	private JComboBox _typeBox;
	/**
	 * The JTextField to allow for input into the OTHER field
	 */
	private JTextField _otherBox;
	
	/**
	 * Default constructor that takes all the information needed to fill the box
	 * and creates it.
	 * 
	 * @param inPlatformOptions The data type options available for the current platform
	 * @param inPlatformDefault The default data type for the current platform
	 * @param curValue The current value of the data type
	 */
	public PlatformTypePane(String[] inPlatformOptions, String inPlatformDefault, String curValue){
		_platformOptions = inPlatformOptions;
		
		this.setLayout(new GridLayout(3,1));
		
		//Create components
		_typeBox = new JComboBox(_platformOptions);
		_typeBox.addItem("Other");
		_otherLabel = new JLabel("Other:");
		_otherBox = new JTextField();
		
		//Test to see if the other option is selected
		_typeBox.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e1) {
				testOther();
			}
		});
		
		//Set the selected value
		//If no curValue, then set to default type
		if(curValue == null || curValue.equals("")){
			_typeBox.setSelectedItem(inPlatformDefault);
		}
		else{
			boolean isOther = true;
			
			for(int i=0; i<inPlatformOptions.length; i++){
				if(inPlatformOptions[i].equals(curValue)){
					_typeBox.setSelectedItem(inPlatformOptions[i]);
					isOther = false;
				}
			}
			
			if(isOther){
				_typeBox.setSelectedItem("Other");
				_otherBox.setText(curValue);
			}
		}
		
		//Add components to pane
		this.add(_typeBox);
		this.add(_otherLabel);
		this.add(_otherBox);
		
		testOther();
	}
	
	/**
	 * Tests to see if other is selected.
	 * If it is then display the other inputs.
	 */
	public void testOther(){
		if(_typeBox.getSelectedItem().equals("Other")){
			_otherLabel.setVisible(true);
			_otherBox.setVisible(true);
		}
		else{
			_otherLabel.setVisible(false);
			_otherBox.setVisible(false);
		}
	}
	
	/**
	 * Method to get the value to be used for the data type
	 * 
	 * @return The data type value to be used
	 */
	public String getDataType(){
		if(_typeBox.getSelectedItem().equals("Other")){
			return _otherBox.getText();
		}
		else{
			return (String) _typeBox.getSelectedItem();
		}
	}
	
	/**
	 * Sets if the values are editable or not.
	 * 
	 * @param inVal If true then enable component, else disable them.
	 */
	public void setEditability(boolean inVal){
		_typeBox.setEnabled(inVal);
		_otherBox.setEditable(inVal);
	}
}